// Funkcje regulujce zachowania barw
// Blaknicie
function colorFlash(color,val) {

   var satval = val.toString(16);
  if (satval.length <=1) satval = "0" + satval;

   var r = "ff"; var g = "ff"; var b = "ff";

   switch(color) {
       case "green" : 
         r = satval;
         b = satval;
         break;
       case "orange" : 
         g = "a7";
         b = satval;
         break;
       case "magenta" :
         g = satval;
         break;
       case "blue" :
         r = g = satval;
         break;
       case "yellow" :
         b = satval;
         break;
       case "red" :
         b = g = satval;
         break;
    }

   var newval = "#"+r+g+b;
   return newval;
}

// Zwizanie zdarzenia z obiektem bez nadpisywania sowa kluczowego 'this'
function bindEventListener(obj, method) {
  return function(event) { method.call(obj, event || window.event)};
}

// Licznik wygaszania koloru
function Counter(id,color,start,finish) {
   var timeval = 25;
   this.count = this.start = start;
   this.finish = finish;
   this.id = id;
   this.countDown = function() {
      this.count+=25;
      if (this.count >= this.finish) {
         document.getElementById(this.id).style.background="transparent";
         this.countDown=null;
         return;
      }
      document.getElementById(id).style.backgroundColor=colorFlash(color,this.count);
      setTimeout(bindEventListener(this,this.countDown),timeval);
   }
}


// Oglne funkcje aplikacji
window.onload = function () {
   document.getElementById("save").onclick=echoPreview;
}

// Podgld i ustawienia kolorw
function echoPreview() {
   var color = document.getElementById("color").value;
   var commentText = document.getElementById("comment").value;
   modText = commentText.split(/\n/).join("<br />");
   var previewElem = document.getElementById("preview");
   previewElem.innerHTML = modText;
   var ctrObj = new Counter("preview", color, 0, 255);
   ctrObj.countDown();
}

